﻿#using System.Threading.Tasks;

#using Tessa.Cards;
#using Tessa.Cards.Numbers;
#using Tessa.Cards.Workflow;
#using Tessa.Extensions.Default.Server.Workflow.KrProcess;
#using Tessa.Extensions.Default.Shared.Workflow.KrProcess.ClientCommandInterpreter;

const string buttonSendAlias = "Send";

if(string.Equals(Dialog.ButtonName, buttonSendAlias, StringComparison.Ordinal))
{
	Dialog.CompleteDialog = false;
	
	var fileManager = this.Resolve<ICardFileManager>();
	var tokenProvider = this.Resolve<IKrTokenProvider>();
	
	var dialogCard = await Dialog.GetDialogCardAsync(cancellationToken: this.CancellationToken);
	
	await using (var container = await fileManager.CreateContainerAsync(dialogCard, cancellationToken: this.CancellationToken))
	{
		// Подготовка контента приложенных и/или изменённых файлов для последующего сохранения.
		foreach(var dFile in container.FileContainer.Files)
		{
			if(!dFile.Content.HasData)
			{
				await dFile.ReplaceAsync(await Dialog.GetFileContentAsync(dialogCard.Files.Single(i => i.RowID == dFile.ID)), this.CancellationToken);
			}
		}
	
		var storeResponse = await container.StoreAsync((c, request, ct) =>
		{
			tokenProvider.CreateToken(request.Card.ID).Set(request.Card.Info);
			return new ValueTask();
		},
		cancellationToken: this.CancellationToken);
		
		this.ValidationResult.Add(storeResponse.ValidationResult);
		if (!storeResponse.ValidationResult.IsSuccessful())
		{
			return;
		}
	}
	
	this.KrScope.TryAddClientCommand(new KrProcessClientCommand(
		DefaultCommandTypes.OpenCard,
		new Dictionary<string, object>(StringComparer.Ordinal)
		{
			[KrConstants.Keys.NewCardID] = dialogCard.ID,
			[KrConstants.Keys.TypeID] = dialogCard.TypeID,
			[KrConstants.Keys.TypeName] = dialogCard.TypeName,
		}));

	var cardRepository = this.Resolve<ICardRepository>();
	var getResponse = await cardRepository.GetAsync(new CardGetRequest()
	{
		CardID = dialogCard.ID,
		RestrictionFlags = CardGetRestrictionFlags.RestrictFiles |
			CardGetRestrictionFlags.RestrictTaskCalendar |
			CardGetRestrictionFlags.RestrictTaskHistory |
			CardGetRestrictionFlags.RestrictTasks
	},
	this.CancellationToken);
	this.ValidationResult.Add(getResponse.ValidationResult);
	if (!getResponse.ValidationResult.IsSuccessful())
	{
		return;
	}

	dialogCard = getResponse.Card;
	
	dialogCard.RemoveNumberQueue();
	dialogCard.RemoveWorkflowQueue();
	dialogCard.RemoveAllButChanged(dialogCard.StoreMode);
	
	var token = tokenProvider.CreateToken(dialogCard);
	token.Set(dialogCard.Info);

	var storeInfo = new Dictionary<string, object>(StringComparer.Ordinal);
	storeInfo.SetStartingProcessName(KrConstants.KrProcessName);
	var startProcessRequest = new CardStoreRequest { Card = dialogCard, Info = storeInfo };
	startProcessRequest.SetIgnorePermissionsWarning();
	var startProcessResponse = await cardRepository.StoreAsync(startProcessRequest, this.CancellationToken);
	this.ValidationResult.Add(startProcessResponse.ValidationResult);
}